#!/bin/bash

if [[ $# -ne 5 ]]; then
	echo "Arguments: blazegraphPath blazegraphNamespace queryFolder timeout outLabel"
	exit 2
fi

timeout=$(($4 * 1000))

echo "Using blazegraph path $1"
echo "Using blazegraph namespace $2"
echo "Using query folder $3"
echo "Using timeout $4 s $timeout ms"

echo "Starting Blazegraph server"
bash $1/runBlazegraph.sh &

echo "Sleeping one minute"
sleep 1m

echo "Opening query folder $3"
for file in $3/*.txt; do
	if [[ ! -e $file ]]; then
		echo "No query file with suffix .txt found in folder $3"
		continue
	fi
	queryName=$(basename $file)
	__dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
	echo "Opening $file"
	echo "Benchmarking $queryName"
	echo "Writing results to $3/output/${queryName%.*}/$5.txt"
	mkdir -p $3/output/
	mkdir -p $3/output/${queryName%.*}
	python ${__dir}/benchmark.py $3/$queryName http://localhost:9999/bigdata/namespace/$2/sparql $4 > $3/output/${queryName%.*}/$5.txt
	echo "[done]"
done

kill $!